package net.minecraft.src;
// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

import java.util.List;
import org.lwjgl.input.Keyboard;

public class GuiBlockColoredMain extends GuiScreen
{

    public GuiBlockColoredMain(EntityPlayer iplayer)
    {
        player = iplayer;
        int hexColor = ((mod_ColoredBlocks.redVal << 16) | (mod_ColoredBlocks.greenVal << 8)) | (mod_ColoredBlocks.blueVal);
        hexString = java.lang.Integer.toHexString( hexColor );
        int dif = 6 - hexString.length();
        for(int i=0; i<dif; i++)
        {
            hexString = (new StringBuilder()).append("0").append(hexString).toString();
        }
        hexInt = java.lang.Integer.parseInt(hexString, 16);
        if(hexInt > 0xffffff)
        {
            hexInt = 0xffffff;
            hexString = "ffffff";
        }
    }

    public void initGui()
    {
        screenTitle = "Enter a hexadecimal RGB value:";
        hexInput = new GuiTextField(this, fontRenderer, width / 2 - 120, 60, 200, 20, hexString);
        hexInput.isFocused = true;
        hexInput.setMaxStringLength(6);
        controlList.clear();
        controlList.add(doneButton = new GuiButton(0, width / 2 - 100, height / 4 + 125, "Done"));
        controlList.add(importButton = new GuiButton(1, width / 2 - 100, height / 4 + 95, mod_ColoredBlocks.importing || mod_ColoredBlocks.importInProgress ? "Cancel Import" : "Load Image"));
        doneButton.enabled = false;
        checkHexInput();
        Keyboard.enableRepeatEvents(true);
    }

    public void updateScreen()
    {
        super.updateScreen();
    }

    public void checkHexInput()
    {   
        boolean flag = hexInput.getText().trim().length() == 6;
        ((GuiButton)controlList.get(0)).enabled = flag;
        ((GuiButton)controlList.get(1)).enabled = flag;
        if(flag)
        {
            hexString = hexInput.getText();
        }
    }

    protected void actionPerformed(GuiButton guibutton)
    {
        if(!guibutton.enabled)
        {
            return;
        }
        if(guibutton.id == 0)
        {
            mod_ColoredBlocks.redVal = (hexInt & 0xff0000) >> 16;
            mod_ColoredBlocks.greenVal = (hexInt & 0x00ff00) >> 8;
            mod_ColoredBlocks.blueVal = (hexInt & 0x0000ff);
            Keyboard.enableRepeatEvents(false);
            mc.displayGuiScreen((GuiScreen)null);
            mc.setIngameFocus();
        }
        if(guibutton.id == 1)
        {
            if(mod_ColoredBlocks.importing || mod_ColoredBlocks.importInProgress)
            {
                mod_ColoredBlocks.importing = false;
                mod_ColoredBlocks.importInProgress = false;
                mod_ColoredBlocks.resetSelectors(mod_ColoredBlocks.mcInst.theWorld);
                mc.displayGuiScreen((GuiScreen)null);
                mc.setIngameFocus();
            }
            else
            {
                ModLoader.OpenGUI(player, new GuiBlockColoredImport(player));
            }
        }
    }

    protected void keyTyped(char c, int i)
    {
        if(validChars.indexOf(c) >= 0 || i == 14 || c == '\r')
        {
            hexInput.textboxKeyTyped(c, i);
            checkHexInput();
            updateColor();
            // if(c == '\r')
            // {
            //     actionPerformed((GuiButton)controlList.get(0));
            //     actionPerformed((GuiButton)controlList.get(1));
            // }
        }
    }

    protected void updateColor()
    {
        hexInt = java.lang.Integer.parseInt(hexString, 16);
        int alphaHexInt = hexInt | 0xff000000;
        drawRect(width / 2 + 100, 55, width / 2 + 130, 85, alphaHexInt);
    }

    public void drawScreen(int i, int j, float f)
    {
        drawDefaultBackground();
        drawCenteredString(fontRenderer, screenTitle, width / 2, 40, 0xffffff);
        int alphaHexInt = hexInt | 0xff000000;
        drawRect(width / 2 + 100 - 1, 55 - 1, width / 2 + 130 + 1, 85 + 1, 0xffa0a0a0);
        drawRect(width / 2 + 100, 55, width / 2 + 130, 85, alphaHexInt);
        hexInput.drawTextBox();
        super.drawScreen(i, j, f);
    }

    private static final String validChars = "0123456789abcdefABCDEF";
    private GuiTextField hexInput;
    private String hexString;
    private int hexInt;
    private GuiButton doneButton;
    private GuiButton importButton;

    protected EntityPlayer player;

    protected String screenTitle;
}
